unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OpenGL, Unit1;
const
  id_Text = 1000;
 
type
  TfrmGL = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
   
  private
    hrc: HGLRC;  
    DC : HDC;
   
  public
     Txt : String;
     Letter : PChar;
     ColorLetter : array [1..3] of GLFloat;
     procedure Axes;
     procedure Grid;
     procedure Points;
  end;
var
  frmGL: TfrmGL;
  max_x, min_x : GLfloat;
  max_y, min_y : GLfloat;
  
implementation

{$R *.DFM}

procedure TfrmGL.FormPaint(Sender: TObject);
const
 n = 2000;
 k = 10;
var
 x, y : GLfloat;
 i : GLint;

begin
 wglMakeCurrent(Canvas.Handle, hrc);

 glViewPort (0, 0, ClientWidth, ClientHeight);

 glClearColor (0.5, 0.5, 0.75, 1.0);
 glClear (GL_COLOR_BUFFER_BIT);

 glEnable (GL_POINT_SMOOTH);
 glPointSize (1);
 glColor3f (1.0, 0.0, 0.5);

 max_x := x_max + k;
 min_x := x_min - k;
 max_y := y_max + k;
 min_y := y_min - k;


 glBegin (GL_POINTS);
  For i := 0 to n do
  begin
   x := min_x + i * (max_x - min_x) / n;
   y := a * sqr(x) + b * x + c;
   glVertex2f (2 * (x - min_x) / (max_x - min_x) - 1, 2 * (y - min_y) / (max_y - min_y) - 1);
  end;
 glEnd;

 Axes;
 Grid;
 Points;

 SwapBuffers(Canvas.Handle);
 wglMakeCurrent(0, 0);
end;

procedure SetDCPixelFormat (hdc : HDC);
var
 pfd : TPixelFormatDescriptor;
 nPixelFormat : Integer;
begin
 FillChar (pfd, SizeOf (pfd), 0);
 pfd.dwFlags  := PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL or PFD_DOUBLEBUFFER;
 
 nPixelFormat := ChoosePixelFormat (hdc, @pfd);
 SetPixelFormat (hdc, nPixelFormat, @pfd);
end;

procedure TfrmGL.FormCreate(Sender: TObject);
begin
 DC := GetDC(Handle);
 SetDCPixelFormat(Canvas.Handle);
 hrc := wglCreateContext(Canvas.Handle);
 wglMakeCurrent(DC, hrc);
 wglUseFontBitmaps(Canvas.Handle, 0, 255, id_Text);
end;

procedure TfrmGL.FormDestroy(Sender: TObject);
begin
 glDeleteLists (id_Text, 255);
 wglMakeCurrent(0, 0);

 wglDeleteContext(hrc);

 ReleaseDC(Handle, DC);
end;

procedure TfrmGL.Axes;
begin
 glLineWidth(5);       
 glColor3f (1.0, 1.0, 1.0);
 glBegin (GL_LINES);
   glVertex2f (2 * (min_x - min_x) / (max_x - min_x) - 1, 2 * (0 - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (max_x - min_x) / (max_x - min_x) - 1, 2 * (0 - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (0 - min_x) / (max_x - min_x) - 1, 2 * (min_y - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (0 - min_x) / (max_x - min_x) - 1, 2 * (max_y - min_y) / (max_y - min_y) - 1);

   glVertex2f (2 * ((- 0.25) - min_x) / (max_x - min_x) - 1, 2 * ((max_y - 0.5) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (0 - min_x) / (max_x - min_x) - 1, 2 * (max_y - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (0 - min_x) / (max_x - min_x) - 1, 2 * (max_y - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (0.25 - min_x) / (max_x - min_x) - 1, 2 * ((max_y - 0.5) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((max_x - 0.5) - min_x) / (max_x - min_x) - 1, 2 * (0.25 - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (max_x - min_x) / (max_x - min_x) - 1, 2 * (0 - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * (max_x - min_x) / (max_x - min_x) - 1, 2 * (0 - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((max_x - 0.5) - min_x) / (max_x - min_x) - 1, 2 * ((- 0.25) - min_y) / (max_y - min_y) - 1);

   glVertex2f (2 * ((- 0.5) - min_x) / (max_x - min_x) - 1, 2 * ((max_y - 0.5) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((- 0.75) - min_x) / (max_x - min_x) - 1, 2 * ((max_y - 1) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((- 0.75) - min_x) / (max_x - min_x) - 1, 2 * ((max_y - 0.5) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((- 0.62) - min_x) / (max_x - min_x) - 1, 2 * ((max_y - 0.75) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((max_x - 0.5) - min_x) / (max_x - min_x) - 1, 2 * ((- 0.5) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((max_x - 0.75) - min_x) / (max_x - min_x) - 1, 2 * ((- 1) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((max_x - 0.75) - min_x) / (max_x - min_x) - 1, 2 * ((- 0.5) - min_y) / (max_y - min_y) - 1);
   glVertex2f (2 * ((max_x - 0.5) - min_x) / (max_x - min_x) - 1, 2 * ((- 1) - min_y) / (max_y - min_y) - 1);
 glEnd;

  glPushMatrix;
  glPushAttrib (GL_ALL_ATTRIB_BITS);

  glListBase(id_Text);

  Letter := '0';
  glRasterPos (2 * (-0.3 - min_x) / (max_x - min_x) - 1, 2 * (-0.5 - min_y) / (max_y - min_y) - 1);
  glCallLists(1, GL_UNSIGNED_BYTE, Letter);

  Letter := '1';
  glRasterPos (2 * (0.95 - min_x) / (max_x - min_x) - 1, 2 * (-0.5 - min_y) / (max_y - min_y) - 1);
  glCallLists(1, GL_UNSIGNED_BYTE, Letter);

  glRasterPos (2 * (-0.5 - min_x) / (max_x - min_x) - 1, 2 * (0.95 - min_y) / (max_y - min_y) - 1);
  glCallLists(1, GL_UNSIGNED_BYTE, Letter);

  glPopAttrib;
  glPopMatrix;
  
end;

procedure TfrmGL.Grid;
var
  i, j0, j : GLInt;
begin
  glEnable (GL_LINE_STIPPLE);
  glLineStipple (1, 4095);

  j0 := Trunc (min_y);
  j := Trunc (max_y);
  glLineWidth(1);
  glColor3f (0.0, 0.5, 5.5);
  glBegin (GL_LINES);
    For i := j0 to j do begin
        glVertex2f (2 * (i - min_x) / (max_x - min_x) - 1, 2 * (min_y - min_y) / (max_y - min_y) - 1);
        glVertex2f (2 * (i - min_x) / (max_x - min_x) - 1, 2 * (max_y - min_y) / (max_y - min_y) - 1);
        glVertex2f (2 * (min_x - min_x) / (max_x - min_x) - 1, 2 * (i - min_y) / (max_y - min_y) - 1);
        glVertex2f (2 * (max_x - min_x) / (max_x - min_x) - 1, 2 * (i - min_y) / (max_y - min_y) - 1);
    end;
  glEnd;

  glDisable (GL_LINE_STIPPLE);

end;

procedure TfrmGL.Points;
begin
 glColor3f (0.0, 5.0, 0.0);
 glPointSize (6);
 glBegin (GL_POINTS);
 glVertex2f (2 * (x0 - min_x) / (max_x - min_x) - 1, 2 * (y0 - min_y) / (max_y - min_y) - 1);
  if D > 0 then
  begin
        glVertex2f (2 * (x1 - min_x) / (max_x - min_x) - 1, 2 * (y1 - min_y) / (max_y - min_y) - 1);
        glVertex2f (2 * (x2 - min_x) / (max_x - min_x) - 1, 2 * (y2 - min_y) / (max_y - min_y) - 1);
  end;
  if D = 0 then
        glVertex2f (2 * (x3 - min_x) / (max_x - min_x) - 1, 2 * (y3 - min_y) / (max_y - min_y) - 1);
  if D <= 0 then
  begin
        glVertex2f (2 * (x4 - min_x) / (max_x - min_x) - 1, 2 * (y4 - min_y) / (max_y - min_y) - 1);
        glVertex2f (2 * (x5 - min_x) / (max_x - min_x) - 1, 2 * (y5 - min_y) / (max_y - min_y) - 1);
        glVertex2f (2 * (x6 - min_x) / (max_x - min_x) - 1, 2 * (y6 - min_y) / (max_y - min_y) - 1);

  end;
 glEnd;

  glPushMatrix;
  glPushAttrib (GL_ALL_ATTRIB_BITS);

  glListBase(id_Text);

  if ((b > 0) and (c > 0)) then
              Txt := Format('y = %g x^2 + %g x + %g', [a, b, c]);
  if ((b < 0) and (c < 0)) then
              Txt := Format('y = %g x^2 %g x %g', [a, b, c]);
  if ((b < 0) and (c > 0)) then
              Txt := Format('y = %g x^2 %g x + %g', [a, b, c]);
  if ((b > 0) and (c < 0)) then
              Txt := Format('y = %g x^2 + %g x %g', [a, b, c]);

  Letter := PChar(Txt);
  glRasterPos (2 * (min_x+1 - min_x) / (max_x - min_x) - 1, 2 * (max_y-0.5 - min_y) / (max_y - min_y) - 1);
  glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);

  Txt := Format ('C ( %.2g, %.2g )', [x0, y0]);
  Letter := PChar(Txt);
  if a < 0
  then glRasterPos (2 * (x0 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y0 + 0.3 - min_y) / (max_y - min_y) - 1)
  else glRasterPos (2 * (x0 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y0 - 0.4 - min_y) / (max_y - min_y) - 1);
  glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);

  if D > 0 then
  begin
        Txt := Format ('A ( %.2g, %.2g )', [x1, y1]);
        Letter := PChar(Txt);
        glRasterPos (2 * (x1 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y1 + 0.3 - min_y) / (max_y - min_y) - 1);
        glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);

        Txt := Format ('B ( %.2g, %.2g )', [x2, y2]);
        Letter := PChar(Txt);
        glRasterPos (2 * (x2 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y2 + 0.3 - min_y) / (max_y - min_y) - 1);
        glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);

        glPopAttrib;
        glPopMatrix;
  end;
  if D = 0 then
  begin
        Txt := Format ('A ( %.2g, %.2g )', [x3, y3]);
        Letter := PChar(Txt);
        glRasterPos (2 * (x3 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y3 + 0.3 - min_y) / (max_y - min_y) - 1);
        glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);
  end;
  if D <= 0 then
  begin
        Txt := Format ('D ( %.2g, %.2g )', [x4, y4]);
        Letter := PChar(Txt);
        glRasterPos (2 * (x4 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y4 + 0.3 - min_y) / (max_y - min_y) - 1);
        glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);

        Txt := Format ('E ( %.2g, %.2g )', [x5, y5]);
        Letter := PChar(Txt);
        glRasterPos (2 * (x5 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y5 + 0.3 - min_y) / (max_y - min_y) - 1);
        glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);

        Txt := Format ('F ( %.2g, %.2g )', [x6, y6]);
        Letter := PChar(Txt);
        glRasterPos (2 * (x6 + 0.3 - min_x) / (max_x - min_x) - 1, 2 * (y6 + 0.3 - min_y) / (max_y - min_y) - 1);
        glCallLists(Length(Letter), GL_UNSIGNED_BYTE, Letter);

        glPopAttrib;
        glPopMatrix;
  end;
end;

end.

